/*
 * Created on Jun 24, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.domain.service.messaging.decode.hl7.structure;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;
import ca.uhn.log.HapiLogFactory;

public class VXR_V03 extends AbstractMessage
{
    public VXR_V03() {
 	   try {
 	      this.add(MSH.class, true, false);
 	      this.add(MSA.class, true, false);
 	      this.add(ERR.class, false, false);
 	      this.add(QRD.class, true, false);
 	      this.add(QRF.class, false, false);
 	      this.add(QAK.class, false, false);
 	      this.add(PID.class, true, false);
 	      this.add(VXR_V03_RXANTE.class, false, true);
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXR_V03 - this is probably a bug in the source code generator.", e);
 	   }
 	}
    
    public MSH getMSH() { 
 	   MSH ret = null;
 	   try {
 	      ret = (MSH)this.get("MSH");
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
 	   }
 	   return ret;
 	}

 	/**
 	 * Returns MSA (Message Acknowledgment) - creates it if necessary
 	 */
 	public MSA getMSA() { 
 	   MSA ret = null;
 	   try {
 	      ret = (MSA)this.get("MSA");
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
 	   }
 	   return ret;
 	}

 	/**
 	 * Returns QRD (Original-Style Query Definition) - creates it if necessary
 	 */
 	public QRD getQRD() { 
 	   QRD ret = null;
 	   try {
 	      ret = (QRD)this.get("QRD");
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
 	   }
 	   return ret;
 	}

 	/**
 	 * Returns QRF (Original Style Query Filter) - creates it if necessary
 	 */
 	public QRF getQRF() { 
 	   QRF ret = null;
 	   try {
 	      ret = (QRF)this.get("QRF");
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
 	   }
 	   return ret;
 	}

 	/**
 	 * Returns PID (Patient identification) - creates it if necessary
 	 */
 	public PID getPID() { 
 	   PID ret = null;
 	   try {
 	      ret = (PID)this.get("PID");
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
 	   }
 	   return ret;
 	}

    
    public QAK getQAK()
    {
        QAK ret = null;
     	try {
     	    ret = (QAK)this.get("QAK");
     	} catch(HL7Exception e) {
     	    HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
     	}
     	return ret;
    }
    
    public int getRXANTEReps()
    {
     	int reps = -1;
        try {
     	    reps = this.getAll("VXR_V03_RXANTE").length;
     	} catch(HL7Exception e) {
     	    HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
     	}
     	return reps;
    }
    
    public VXR_V03_RXANTE getRXANTE(int rep) throws HL7Exception
    {
        return (VXR_V03_RXANTE)this.get("VXR_V03_RXANTE", rep);
    }
}
